package com.usercentrics.sdk.ui.userAgent

import android.app.UiModeManager
import android.content.Context.UI_MODE_SERVICE
import android.content.res.Configuration
import android.os.Build
import com.usercentrics.sdk.BuildKonfig
import com.usercentrics.sdk.UsercentricsContext
import com.usercentrics.sdk.UsercentricsOptions
import com.usercentrics.sdk.ui.PredefinedUIMediator

internal actual class NativeUserAgentProvider actual constructor(
    private val context: UsercentricsContext?,
    private val userAgentSDKTypeEvaluator: UserAgentSDKTypeEvaluator,
    predefinedUIMediator: PredefinedUIMediator,
    private val options: UsercentricsOptions,
) : UserAgentProvider(predefinedUIMediator) {

    companion object {
        private const val amazonFeatureFireTV = "amazon.hardware.fire_tv"
    }

    override fun provide(): UsercentricsUserAgentInfo {
        return UsercentricsUserAgentInfo(
            platform = getPlatformName(),
            osVersion = Build.VERSION.SDK_INT.toString(),
            sdkVersion = BuildKonfig.sdk_version,
            appID = context!!.packageName,
            predefinedUIVariant = predefinedUIVariantValue,
            appVersion = getAppVersion(),
            sdkType = userAgentSDKTypeEvaluator.eval(),
            consentMediation = options.consentMediation,
        )
    }

    private fun getPlatformName(): String {
        val uiModeManager = this.context!!.getSystemService(UI_MODE_SERVICE) as? UiModeManager
        val currentModeType = uiModeManager?.currentModeType
        return when {
            currentModeType == Configuration.UI_MODE_TYPE_TELEVISION -> "Android-TV"
            currentModeType == Configuration.UI_MODE_TYPE_CAR -> "Android-Car"
            currentModeType == Configuration.UI_MODE_TYPE_DESK -> "Android-Desktop"
            currentModeType == Configuration.UI_MODE_TYPE_WATCH -> "Android-Watch"
            isAmazonFireTV() -> "Android-Amazon-FireTV"
            isTabletDevice() -> "Android-Tablet"
            else -> "Android"
        }
    }

    private fun isAmazonFireTV(): Boolean {
        return this.context!!.packageManager.hasSystemFeature(amazonFeatureFireTV)
    }

    private fun isTabletDevice(): Boolean {
        val screenLayout = this.context!!.resources.configuration.screenLayout and Configuration.SCREENLAYOUT_SIZE_MASK
        return screenLayout >= Configuration.SCREENLAYOUT_SIZE_LARGE
    }

    private fun getAppVersion(): String {
        return runCatching {
            this.context!!.packageManager.getPackageInfo(this.context.packageName, 0).versionName!!
        }.getOrElse { "unknown-version" }
    }
}
