package com.usercentrics.tcf.core.model

internal actual class SortedSet<T : Comparable<T>> {

    private val set = sortedSetOf<T>()

    actual fun get(): Set<T> = set

    actual fun add(value: T) {
        set.add(value)
    }

    actual fun contains(value: T): Boolean = set.contains(value)

    actual fun max(): T? = set.lastOrNull()
}
