package com.usercentrics.sdk

import kotlin.concurrent.Volatile

private typealias Callback<T> = (T) -> Unit

internal class Observable<T> {

    private val callbackList = mutableListOf<Callback<T>?>()

    @Volatile
    var value: T? = null
        private set

    fun subscribe(callback: Callback<T>) {
        val currentValue = value
        if (currentValue != null) {
            callback(currentValue)
            return
        }
        callbackList.add(callback)
    }

    fun emit(value: T) {
        set(value)
        invokeCallback()
    }

    fun set(value: T) {
        this.value = value
    }

    fun disposeAll() {
        callbackList.clear()
        disposeValue()
    }

    fun disposeValue() {
        this.value = null
    }

    fun invokeCallback() {
        val actualValue = value ?: return

        val callbacksToNotify = callbackList.toList()
        callbackList.clear()

        callbacksToNotify.forEach { it?.invoke(actualValue) }
    }
}
