package com.usercentrics.sdk

import com.usercentrics.sdk.core.application.Application

internal interface SDKProvider {
    fun provide(application: Application, options: UsercentricsOptions, context: UsercentricsContext?): UsercentricsSDK
}

internal class MainSDKProvider : SDKProvider {
    override fun provide(application: Application, options: UsercentricsOptions, context: UsercentricsContext?): UsercentricsSDK {
        return UsercentricsSDKImpl(application, options)
    }
}

internal var usercentricsProvider: SDKProvider = defaultSDKProvider()

internal fun defaultSDKProvider(): MainSDKProvider {
    return MainSDKProvider()
}
