package com.usercentrics.sdk

import com.usercentrics.sdk.event.MediationConsentEvent
import com.usercentrics.sdk.event.UpdatedConsentEvent
import com.usercentrics.sdk.mediation.data.MediationResultPayload

object UsercentricsEvent {

    internal val updatedConsentEvent = UpdatedConsentEvent()
    internal val mediationConsentEvent = MediationConsentEvent()

    fun onConsentUpdated(callback: (UpdatedConsentPayload) -> Unit): UsercentricsDisposableEvent<UpdatedConsentPayload> {
        val disposableEvent = UsercentricsDisposableEvent(callback)
        updatedConsentEvent.subscribe(disposableEvent)

        return disposableEvent
    }

    fun onConsentMediation(callback: (MediationResultPayload) -> Unit): UsercentricsDisposableEvent<MediationResultPayload> {
        val disposableEvent = UsercentricsDisposableEvent(callback)
        mediationConsentEvent.subscribe(disposableEvent)

        return disposableEvent
    }

    internal fun tearDown() {
        updatedConsentEvent.tearDown()
        mediationConsentEvent.tearDown()
    }
}
