package com.usercentrics.sdk

import com.usercentrics.sdk.v2.location.data.UsercentricsLocation
import kotlinx.serialization.Serializable

@Serializable
data class UsercentricsReadyStatus(
    /** True, if consent has never been collected or some service has changed thus requiring a consent update. False, if consent has been collected and no update is required. */
    val shouldCollectConsent: Boolean,
    /** List of services with consent choices. */
    val consents: List<UsercentricsServiceConsent>,
    /** Object containing information about Geolocation Rulesets, when enabled in the account */
    val geolocationRuleset: GeolocationRuleset?,
    /** Current location of User */
    val location: UsercentricsLocation,
)
