package com.usercentrics.sdk

import com.usercentrics.sdk.models.settings.LegacyConsentHistoryEntry
import com.usercentrics.sdk.models.settings.LegacyService
import com.usercentrics.sdk.models.settings.UsercentricsConsentType
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory
import kotlinx.serialization.Contextual
import kotlinx.serialization.Serializable

/** The current status of a service. */
@Serializable
data class UsercentricsServiceConsent(
    /** A unique ID that represents the legal specifications of the service. */
    val templateId: String,
    /** True if consent was given, False if not. */
    val status: Boolean,
    /** The consent history chronologically ordered. */
    val history: List<UsercentricsConsentHistoryEntry>,
    /** The type of the current consent status. E.g. 'Explicit'. */
    @Contextual val type: UsercentricsConsentType?,
    /** The data controller that determines the purposes and the means of the processed data.The data processor is usually a third party external to the company. */
    val dataProcessor: String,
    /** The configuration version of the service. */
    val version: String,
    /** True if the service is essential, False if not. */
    val isEssential: Boolean,
    /** The corresponding category of this service**/
    val category: String
)

internal fun LegacyService.mapConsent(): UsercentricsServiceConsent {
    return UsercentricsServiceConsent(
        templateId = id,
        status = consent.status,
        history = consent.history.map { it.mapHistoryEntry() },
        type = consent.history.lastOrNull()?.type,
        dataProcessor = name,
        version = version,
        isEssential = isEssential,
        category = categorySlug
    )
}

/**  The consent history entry. */
@Serializable
data class UsercentricsConsentHistoryEntry(
    /** True if consent was given, False if not. */
    val status: Boolean,
    /** The type of the current consent status. E.g. 'Explicit'. */
    @Contextual val type: UsercentricsConsentType,
    /** The UNIX timestamp in millisecons of the consent. */
    val timestampInMillis: Long,
)

internal fun LegacyConsentHistoryEntry.mapHistoryEntry(): UsercentricsConsentHistoryEntry {
    return UsercentricsConsentHistoryEntry(
        status = status,
        type = type,
        timestampInMillis = timestampInMillis,
    )
}
