package com.usercentrics.sdk.acm.repository

import com.usercentrics.sdk.AdTechProvider
import com.usercentrics.sdk.acm.api.AdditionalConsentModeApi
import com.usercentrics.sdk.acm.data.AdditionalConsentModeListResponse
import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.network.NetworkOrchestrator

internal class AdditionalConsentModeRemoteRepositoryImpl(
    private val api: AdditionalConsentModeApi,
    private val jsonParser: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy,
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), AdditionalConsentModeRemoteRepository {

    override suspend fun loadAdTechProviderList(selectedIds: List<Int>, consentedIds: List<Int>): List<AdTechProvider> {
        val response = resolveHttp2 { api.loadAdTechProviderList(getApiHeaders()) }
        val listResponse = jsonParser.decodeFromString<AdditionalConsentModeListResponse>(response.body)

        return mapAndFilterSelectedProviders(listResponse, selectedIds, consentedIds)
    }

    override fun etagKey(): String {
        return EtagCacheStorage.additionalConsentModeDir
    }

    private fun mapAndFilterSelectedProviders(listResponse: AdditionalConsentModeListResponse, selectedIds: List<Int>, consentedIds: List<Int>): List<AdTechProvider> {
        return listResponse.providers.mapNotNull { entry ->
            val id = entry.key.toIntOrNull()

            if (id == null || !selectedIds.contains(id)) {
                return@mapNotNull null
            }
            AdTechProvider(
                id = id,
                name = entry.value[0],
                privacyPolicyUrl = entry.value[1],
                consent = consentedIds.contains(id)
            )
        }
    }
}
