package com.usercentrics.sdk.core.application

import com.usercentrics.sdk.acm.service.AdditionalConsentModeService
import com.usercentrics.sdk.core.ClassLocator
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.core.settings.SettingsOrchestrator
import com.usercentrics.sdk.domain.api.http.HttpClient
import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.lifecycle.ApplicationLifecycleListener
import com.usercentrics.sdk.lifecycle.BillingSessionLifecycleCallback
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.facade.IMediationFacade
import com.usercentrics.sdk.predefinedUI.PredefinedUIApplication
import com.usercentrics.sdk.services.api.BillingApi
import com.usercentrics.sdk.services.api.NetworkResolver
import com.usercentrics.sdk.services.billing.BillingService
import com.usercentrics.sdk.services.ccpa.ICcpa
import com.usercentrics.sdk.services.dataFacade.DataFacade
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage
import com.usercentrics.sdk.services.initialValues.InitialValuesStrategy
import com.usercentrics.sdk.services.settings.IGeneratorIds
import com.usercentrics.sdk.services.settings.ISettingsLegacy
import com.usercentrics.sdk.services.tcf.TCFUseCase
import com.usercentrics.sdk.ui.PredefinedUIMediator
import com.usercentrics.sdk.ui.userAgent.UserAgentProvider
import com.usercentrics.sdk.v2.analytics.facade.IAnalyticsFacade
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher
import com.usercentrics.sdk.v2.consent.service.ConsentsService
import com.usercentrics.sdk.v2.cookie.service.UsercentricsCookieInformationService
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.file.IFileStorage
import com.usercentrics.sdk.v2.language.facade.ILanguageFacade
import com.usercentrics.sdk.v2.language.service.ILanguageService
import com.usercentrics.sdk.v2.location.service.ILocationService
import com.usercentrics.sdk.v2.ruleset.service.IRuleSetService
import com.usercentrics.sdk.v2.settings.facade.SettingsFacade
import com.usercentrics.sdk.v2.settings.service.ISettingsService
import com.usercentrics.sdk.v2.translation.service.ITranslationService
import kotlinx.coroutines.CoroutineDispatcher

internal interface Application {

    var networkStrategy: Lazy<INetworkStrategy>

    val userAgentProvider: UserAgentProvider
    var httpClient: Lazy<HttpClient>
    var networkResolver: Lazy<NetworkResolver>
    val httpInstance: HttpRequests
    val logger: UsercentricsLogger
    val billingApi: BillingApi
    val languageService: ILanguageService
    val settingsService: ISettingsService
    val cookieInformationService: UsercentricsCookieInformationService
    val translationService: ITranslationService
    val settingsFacade: SettingsFacade
    var consentsService: Lazy<ConsentsService>
    var initialValuesStrategy: Lazy<InitialValuesStrategy>
    val uiDependencyManager: PredefinedUIApplication
    var lifecycleListener: Lazy<ApplicationLifecycleListener>
    val billingSessionLifecycleCallback: BillingSessionLifecycleCallback

    var defaultKeyValueStorage: Lazy<KeyValueStorage>
    var customKeyValueStorage: Lazy<KeyValueStorage>
    var storageInstance: Lazy<DeviceStorage>
    var billingService: Lazy<BillingService>
    var languageFacade: Lazy<ILanguageFacade>
    var locationService: Lazy<ILocationService>
    var settingsInstance: Lazy<ISettingsLegacy>
    val dataFacadeInstance: DataFacade
    var ccpaInstance: Lazy<ICcpa>
    var tcfInstance: Lazy<TCFUseCase>
    val jsonParserInstance: JsonParser
    val mainDispatcher: CoroutineDispatcher
    val defaultDispatcher: CoroutineDispatcher
    val dispatcher: Dispatcher
    var etagCacheStorage: Lazy<IEtagCacheStorage>
    var fileStorage: Lazy<IFileStorage>
    val analyticsFacade: Lazy<IAnalyticsFacade>
    var classLocator: Lazy<ClassLocator>
    val predefinedUIMediator: PredefinedUIMediator
    var settingsOrchestrator: Lazy<SettingsOrchestrator>
    var ruleSetService: Lazy<IRuleSetService>
    var mediationFacade: Lazy<IMediationFacade>
    var additionalConsentModeService: Lazy<AdditionalConsentModeService>
    var generatorIds: Lazy<IGeneratorIds>

    fun boot()
    fun tearDown(clearStorage: Boolean)
}
