package com.usercentrics.sdk.core.settings

import com.usercentrics.sdk.Observable
import com.usercentrics.sdk.UsercentricsOptions

internal interface SettingsOrchestrator {

    val settingsIdObservable: Observable<String>

    // TODO should we remove this value from the interface in favor of `settingsIdObservable` ?
    val activeSettingsId: String

    val jsonFileLanguage: String
    val noShow: Boolean

    suspend fun boot(options: UsercentricsOptions)
    suspend fun coldInitialize(controllerId: String): Result<Unit>
    suspend fun loadSettings(controllerId: String, language: String? = null): Result<Unit>

    fun isLanguageAlreadySelected(language: String): Boolean
    fun isLanguageAvailable(language: String): Boolean
}
