package com.usercentrics.sdk.core.time

internal expect class DateTime {

    companion object {
        var nowMocked: DateTime?
    }

    val year: Int
    val month: Int
    val day: Int
    val hours: Int
    val minutes: Int
    val seconds: Int

    constructor()
    constructor(timestamp: Long)
    constructor(utcISOString: String)

    fun timestamp(): Long

    fun addSeconds(amount: Int): DateTime
    fun addDays(amount: Int): DateTime
    fun addMonths(amount: Int): DateTime

    fun diffInDays(dateTime: DateTime): Int

    fun formatLocalTimezone(): String

    fun atMidnight(): DateTime

    operator fun compareTo(other: DateTime): Int
    override fun equals(other: Any?): Boolean
    override fun hashCode(): Int
}
