package com.usercentrics.sdk.event

import com.usercentrics.sdk.UsercentricsDisposableEvent

internal open class BaseUsercentricsEvent<T> {

    private val eventCallbacks = mutableListOf<UsercentricsDisposableEvent<T>?>()
    private var payloadBuffer: T? = null

    fun subscribe(disposableEvent: UsercentricsDisposableEvent<T>) {
        eventCallbacks.add(disposableEvent)

        val buffer = payloadBuffer
        if (buffer != null) {
            disposableEvent.call(buffer)
            clearBuffer()
        }
    }

    fun emit(value: T) {
        val callbacks = eventCallbacks
        if (callbacks.isEmpty()) {
            payloadBuffer = value
            return
        }
        callbacks.forEach { it?.call(value) }
    }

    fun clearBuffer() {
        payloadBuffer = null
    }

    fun tearDown() {
        eventCallbacks.clear()
        payloadBuffer = null
    }
}
