package com.usercentrics.sdk.lifecycle

import com.usercentrics.sdk.core.settings.SettingsOrchestrator
import com.usercentrics.sdk.services.billing.BillingService

internal class BillingSessionLifecycleCallback(
    private val billingService: BillingService,
    private val settingsOrchestrator: SettingsOrchestrator,
) : LifecycleListenerCallback {

    override fun invoke() {
        settingsOrchestrator.settingsIdObservable.subscribe {
            billingService.reportSession(it)
        }
    }
}
