package com.usercentrics.sdk.log

import com.usercentrics.sdk.models.common.UsercentricsLoggerLevel

internal class UsercentricsLoggerImpl(
    private val level: UsercentricsLoggerLevel,
    private val writer: LoggerWriter,
) : UsercentricsLogger {

    companion object {
        private const val PREFIX = "[USERCENTRICS]"
    }

    override fun debug(message: String, cause: Throwable?) {
        if (level == UsercentricsLoggerLevel.DEBUG) {
            write(UsercentricsLoggerLevel.DEBUG, message, cause)
        }
    }

    override fun warning(message: String, cause: Throwable?) {
        if (level.ordinal >= UsercentricsLoggerLevel.WARNING.ordinal) {
            write(UsercentricsLoggerLevel.WARNING, message, cause)
        }
    }

    override fun error(message: String, cause: Throwable?) {
        if (level.ordinal >= UsercentricsLoggerLevel.ERROR.ordinal) {
            write(UsercentricsLoggerLevel.ERROR, message, cause)
        }
    }

    private fun write(targetLevel: UsercentricsLoggerLevel, message: String, cause: Throwable?) {
        writer.println("$PREFIX[${targetLevel.name}] $message${appendCause(cause)}")
    }

    private fun appendCause(cause: Throwable?): String {
        return if (cause != null) {
            " | cause: ${cause.stackTraceToString()}"
        } else {
            ""
        }
    }
}
