package com.usercentrics.sdk.mediation

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.data.MediationGranularConsent
import com.usercentrics.sdk.models.common.UsercentricsVariant

internal abstract class MediationSDK(
    open val name: String,
    open val logger: UsercentricsLogger,
    open val vendorId: Int? = null,
) {

    protected fun logException(ex: Exception) {
        logger.debug("Failed to apply consent to $name", ex)
    }

    abstract fun apply(consent: Boolean, variant: UsercentricsVariant): Boolean

    open fun applyGranular(granularConsent: MediationGranularConsent): Boolean {
        return false
    }
}
