package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.data.AdjustMediationResult
import com.usercentrics.sdk.mediation.data.MediationGranularConsent

const val name = "Adjust"

internal abstract class AdjustMediation(
    open val name: String,
    open val logger: UsercentricsLogger
) {

    protected fun logException(ex: Exception) {
        logger.debug("Failed to apply consent to $name", ex)
    }

    abstract val templateId: String

    abstract fun apply(templateId: String, consent: Boolean): AdjustMediationResult

    abstract fun canMediate(templateId: String): Boolean

    abstract fun isAvailable(consentedTemplateIds: Set<String>): Boolean

    abstract fun signalGranularConsent(vendorId: Int?, granularConsent: MediationGranularConsent): Boolean
}
