package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.data.AdjustMediationResult
import com.usercentrics.sdk.mediation.data.MediationGranularConsent
import com.usercentrics.sdk.mediation.data.UsercentricsMediation
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.adjustTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.appleAdsTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.facebookTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.googleAdsTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.googleMarketingPlatformTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.snapchatTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.tencentTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.tikTokSanTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.twitterTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.yahooGeminiTemplateId
import com.usercentrics.sdk.mediation.data.UsercentricsMediation.Adjust.yahooJapanSearchTemplateId

internal class AdjustMediationImpl(
    name: String,
    logger: UsercentricsLogger,
    private val adjustSDK: AdjustSDKInterface
) : AdjustMediation(name, logger) {

    private val supportedGranularVendorIds: List<Int> = listOf(UsercentricsMediation.GOOGLE_VENDOR_ID)

    override val templateId: String = adjustTemplateId

    override fun apply(templateId: String, consent: Boolean): AdjustMediationResult {
        when (templateId) {
            this.templateId -> {
                return AdjustMediationResult("Adjust", adjustSDK.addAdjustGeneralConsent(consent))
            }
            appleAdsTemplateId -> {
                return AdjustMediationResult("AppleAds", addPartnerSharingSetting("apple_ads", consent))
            }
            facebookTemplateId -> {
                return AdjustMediationResult("Facebook", addPartnerSharingSetting("facebook", consent))
            }
            googleAdsTemplateId -> {
                return AdjustMediationResult("GoogleAds", addPartnerSharingSetting("adwords", consent))
            }
            googleMarketingPlatformTemplateId -> {
                return AdjustMediationResult("GoogleMarketingPlatform", addPartnerSharingSetting("google_marketing_platform", consent))
            }
            snapchatTemplateId -> {
                return AdjustMediationResult("Snapchat", addPartnerSharingSetting("snapchat", consent))
            }
            tencentTemplateId -> {
                return AdjustMediationResult("Tencent", addPartnerSharingSetting("tencent", consent))
            }
            tikTokSanTemplateId -> {
                return AdjustMediationResult("TikTokSan", addPartnerSharingSetting("tiktok_san", consent))
            }
            twitterTemplateId -> {
                return AdjustMediationResult("Twitter", addPartnerSharingSetting("twitter", consent))
            }
            yahooGeminiTemplateId -> {
                return AdjustMediationResult("YahooGemini", addPartnerSharingSetting("yahoo_gemini", consent))
            }
            yahooJapanSearchTemplateId -> {
                return AdjustMediationResult("YahooJapanSearch", addPartnerSharingSetting("yahoo_japan_search", consent))
            }
        }
        return AdjustMediationResult("UNKNOWN", false)
    }

    override fun canMediate(templateId: String): Boolean {
        return UsercentricsMediation.Adjust.getTemplateIds().contains(templateId)
    }

    override fun signalGranularConsent(vendorId: Int?, granularConsent: MediationGranularConsent): Boolean {
        if (vendorId == null || !supportedGranularVendorIds.contains(vendorId)) {
            return false
        }
        return adjustSDK.signalGooglePartnerFlags(granularConsent)
    }

    override fun isAvailable(consentedTemplateIds: Set<String>): Boolean {
        return consentedTemplateIds.contains(this.templateId)
    }

    private fun addPartnerSharingSetting(partnerName: String, consent: Boolean): Boolean {
        return adjustSDK.addPartnerSharingSetting(partnerName, consent)
    }
}
