package com.usercentrics.sdk.models.api

import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonTransformingSerializer

/**
 * String or List Serializer
 * @suppress
 * */
internal object StringOrListSerializer : JsonTransformingSerializer<List<String>>(ListSerializer(String.serializer())) {

    // If response is not an array, then it is a single object that should be wrapped in the array
    override fun transformDeserialize(element: JsonElement): JsonElement {
        return if (element !is JsonArray) {
            JsonArray(listOf(element))
        } else {
            element
        }
    }
}
