package com.usercentrics.sdk.services.ccpa

import com.usercentrics.ccpa.CCPAData
import com.usercentrics.ccpa.CcpaApi
import com.usercentrics.sdk.core.time.DateTime
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage

internal class Ccpa(
    private val storage: DeviceStorage,
    private val logger: UsercentricsLogger
) : ICcpa {
    private val ccpaVersion = 1

    var isOptedOut: Boolean? = null
    var iabAgreementExists: Boolean? = null

    private val ccpaInstance: CcpaApi = CcpaApi(storage.toCcpaStorage()) { debugMsg ->
        logger.debug(debugMsg)
    }

    override fun initialize(iabAgreementExists: Boolean?) {
        this.iabAgreementExists = iabAgreementExists
        val uspData = this.getCCPAData()
        isOptedOut = uspData.optedOut
    }

    override fun getCCPAData(): CCPAData {
        return ccpaInstance.getPrivacyData(ccpaVersion)
    }

    override fun getCCPADataAsString(): String {
        return ccpaInstance.getPrivacyDataAsString(ccpaVersion)
    }

    override fun setCcpaStorage(isOptedOut: Boolean, isNoticeGiven: Boolean?) {
        this.isOptedOut = isOptedOut

        storage.setCcpaTimestampInMillis(DateTime().timestamp())

        val ccpaData = CCPAData(
            version = ccpaVersion,
            noticeGiven = isNoticeGiven,
            optedOut = isOptedOut,
            lspact = iabAgreementExists,
        )
        ccpaInstance.setPrivacyData(ccpaVersion, ccpaData)
    }

    override fun setNotApplicable() {
        isOptedOut = null

        storage.setCcpaTimestampInMillis(0)

        val ccpaData = CCPAData(
            version = ccpaVersion,
            noticeGiven = null,
            optedOut = null,
            lspact = null,
        )
        ccpaInstance.setPrivacyData(ccpaVersion, ccpaData)
    }
}
