package com.usercentrics.sdk.services.deviceStorage

import com.usercentrics.ccpa.CCPAStorage
import com.usercentrics.sdk.models.common.UserSessionDataConsent
import com.usercentrics.sdk.models.settings.LegacyExtendedSettings
import com.usercentrics.sdk.models.settings.LegacyService
import com.usercentrics.sdk.services.deviceStorage.models.ConsentsBuffer
import com.usercentrics.sdk.services.deviceStorage.models.StorageSessionEntry
import com.usercentrics.sdk.services.deviceStorage.models.StorageSettings
import com.usercentrics.sdk.services.deviceStorage.models.StorageTCF

internal interface DeviceStorage {

    fun init()

    fun clear()

    fun storeValuesDefaultStorage(values: Map<String, Any>)
    fun toCcpaStorage(): CCPAStorage

    fun setCcpaTimestampInMillis(timestampInMillis: Long)
    fun getCcpaTimestampInMillis(): Long?

    fun setSessionTimestamp(sessionTimestamp: Long)
    fun getSessionTimestamp(): Long?

    fun bootSettings(settingsId: String)
    fun fetchSettings(): StorageSettings

    fun lastInteractionTimestamp(): Long?
    fun getSettingsVersion(): String
    fun getSettingsId(): String
    fun getControllerId(): String
    fun getSettingsLanguage(): String
    fun getUserSessionDataConsents(): List<UserSessionDataConsent>
    fun saveSettings(settings: LegacyExtendedSettings, services: List<LegacyService>)

    fun getConsentBuffer(): ConsentsBuffer
    fun setConsentBuffer(buffer: ConsentsBuffer)

    fun bootTCFData(settingsId: String): StorageTCF
    fun saveTCFData(tcfData: StorageTCF)
    fun getTCFData(): StorageTCF
    fun getActualTCFSettingsId(): String
    fun saveActualTCFSettingsId(actualSettingsId: String)

    fun fetchCcpaString(): String

    fun addSessionToBuffer(currentTime: Long, settingsId: String)
    fun getAndEraseSessionBuffer(): List<StorageSessionEntry>
    fun saveABTestingVariant(variant: String)
    fun getABTestingVariant(): String?

    fun getUserActionRequired(): Boolean
    fun clearUserActionRequired()

    fun saveACString(acString: String)
    fun getACString(): String

    fun deleteSettingsThatDoNotMatch(settingsIds: Set<String>)
    fun clearTCFStorageEntries()
}
