package com.usercentrics.sdk.services.deviceStorage

import kotlin.jvm.JvmName

internal interface KeyValueStorage {

    fun put(key: String, value: String)
    fun put(key: String, value: Int)
    fun put(key: String, value: Long)

    @Suppress("INAPPLICABLE_JVM_NAME")
    @JvmName("putStringMap")
    fun put(values: Map<String, String>)

    @Suppress("INAPPLICABLE_JVM_NAME")
    @JvmName("putIntegerMap")
    fun put(values: Map<String, Int>)

    fun putValuesMap(values: Map<String, Any>)

    fun getStringWithKeyStartingWith(pattern: String): Map<String, String>

    fun getString(key: String, defaultValue: String?): String?
    fun getNumber(key: String, defaultValue: Int): Int
    fun getLong(key: String, defaultValue: Long): Long

    fun deleteKey(key: String)
    fun hasKey(key: String): Boolean

    @Deprecated("This should only be used in the hotfix 1.12.6 special migration for tvOS")
    fun purgeStorage()

    fun deleteKeysThatDoNotMatch(pattern: String, values: Set<String>)

    fun deleteAll(exceptions: List<String>)
}
