package com.usercentrics.sdk.services.deviceStorage.migrations

import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.services.deviceStorage.StorageHolder
import com.usercentrics.sdk.services.deviceStorage.StorageKeys
import com.usercentrics.sdk.services.deviceStorage.models.StorageTCF
import kotlinx.serialization.json.*

internal class MigrationToVersion6(
    storageHolder: StorageHolder,
    private val jsonParser: JsonParser
) : Migration(storageHolder, 6) {

    override fun migrate() {
        val settingsId = migrateSettings()

        if (settingsId != null) {
            migrateTCF(settingsId)
        }
    }

    private fun migrateSettings(): String? {
        val settingsValue = storageHolder.usercentricsKeyValueStorage.getString("settings", null)
        if (settingsValue.isNullOrBlank()) {
            return null
        }
        val settingsJsonObject = jsonParser.decodeFromString<JsonObject>(settingsValue)

        val settingsIdValue = settingsJsonObject["id"]?.jsonPrimitive?.content
        if (settingsIdValue.isNullOrBlank()) {
            return null
        }

        storageHolder.usercentricsKeyValueStorage.apply {
            put("${StorageKeys.SETTINGS_PATTERN.text}$settingsIdValue", settingsValue)
            deleteKey("settings")
        }
        return settingsIdValue
    }

    private fun migrateTCF(settingsId: String) {
        val tcfValue = storageHolder.usercentricsKeyValueStorage.getString("tcf", null)
        if (tcfValue.isNullOrBlank()) {
            return
        }

        var tcfStorage = jsonParser.decodeFromString<StorageTCF>(tcfValue)

        val acString = storageHolder.defaultKeyValueStorage.getString("IABTCF_AddtlConsent", "")
        tcfStorage = tcfStorage.copy(acString = acString)

        val tcfWithAcString = jsonParser.encodeToString(tcfStorage)

        storageHolder.usercentricsKeyValueStorage.apply {
            put("${StorageKeys.TCF_PATTERN.text}$settingsId", tcfWithAcString)
            put(StorageKeys.ACTUAL_TCF_SETTINGS_ID.text, settingsId)
            deleteKey("tcf")
        }
    }
}
