package com.usercentrics.sdk.services.deviceStorage.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class StorageTCF(
    val tcString: String = "",
    @SerialName("v")
    val vendorsDisclosedMap: Map<Int, StorageVendor> = emptyMap(),
    val acString: String? = null,
)

@Serializable
internal data class StorageVendor(
    @SerialName("li")
    val legitimateInterestPurposeIds: List<Int>,
    @SerialName("p")
    val consentPurposeIds: List<Int>,
    @SerialName("sp")
    val specialPurposeIds: List<Int>,
) {
    companion object {
        val empty = StorageVendor(emptyList(), emptyList(), emptyList())
    }

    fun isEmpty(): Boolean {
        return legitimateInterestPurposeIds.isEmpty() &&
                consentPurposeIds.isEmpty() &&
                specialPurposeIds.isEmpty()
    }

    fun contains(other: StorageVendor): Boolean {
        return this.legitimateInterestPurposeIds.containsAll(other.legitimateInterestPurposeIds) &&
                this.consentPurposeIds.containsAll(other.consentPurposeIds) &&
                this.specialPurposeIds.containsAll(other.specialPurposeIds)
    }
}
