package com.usercentrics.sdk.services.settings

import com.usercentrics.sdk.core.hash.SHA256
import com.usercentrics.sdk.core.hash.UUID

internal class GeneratorIds: IGeneratorIds {
    override fun generateProcessorId(): String {
        return hashFunction(randomUuid())
    }

    override fun generateControllerId(): String {
        return hashFunction(randomUuid())
    }

    private fun hashFunction(input: String): String {
        return SHA256.digest(input)
    }

    private fun randomUuid(): String {
        return UUID.random()
    }
}
