package com.usercentrics.sdk.services.tcf

import com.usercentrics.sdk.services.deviceStorage.models.StorageVendor
import com.usercentrics.sdk.services.tcf.interfaces.TCFData
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisions

internal interface TCFUseCase {

    suspend fun initialize(settingsId: String): Result<Unit>

    fun restore(tcString: String, acString: String, vendorsDisclosed: Map<Int, StorageVendor>)
    fun acceptAllDisclosed(fromLayer: TCFDecisionUILayer)
    fun denyAllDisclosed(fromLayer: TCFDecisionUILayer)
    fun updateChoices(decisions: TCFUserDecisions, fromLayer: TCFDecisionUILayer)
    suspend fun changeLanguage(language: String): Result<Unit>
    fun getTCFData(): TCFData
    fun setCmpId(id: Int)
    fun getGdprAppliesOnTCF(): Boolean
    fun getResurfacePurposeChanged(): Boolean
    fun getResurfacePeriodEnded(): Boolean
    fun getResurfaceVendorAdded(): Boolean
    fun getSettingsTCFPolicyVersion(): Int
    fun getStoredTcStringPolicyVersion(): Int
    fun getHideNonIabOnFirstLayer(): Boolean
    fun updateIABTCFKeys(tcString: String)
    fun clearTCFConsentsData()
    fun getResurfaceATPChanged(): Boolean
}
