package com.usercentrics.sdk.services.tcf.interfaces

/** A user's consent decision on all TCF options */
data class TCFUserDecisions(
    /** A user's consent decision on TCF purposes */
    val purposes: List<TCFUserDecisionOnPurpose>?,
    /** A user's consent decision on TCF special features */
    val specialFeatures: List<TCFUserDecisionOnSpecialFeature>?,
    /** A user's consent decision on TCF vendors */
    val vendors: List<TCFUserDecisionOnVendor>?,
    /** A user's consent decision on Google Ad Tech Providers */
    val adTechProviders: List<AdTechProviderDecision> = emptyList(),
)

/** A user's consent decision for a single purpose */
data class TCFUserDecisionOnPurpose(
    override var id: Int,
    override var consent: Boolean?,
    override var legitimateInterestConsent: Boolean?
) : BaseTCFUserDecision, TCFConsentWithLegitimateInterestDecision

/** A user's consent decision for a single special feature */
data class TCFUserDecisionOnSpecialFeature(
    override var id: Int,
    override var consent: Boolean?
) : BaseTCFUserDecision

/** A user's consent decision for a single vendor */
data class TCFUserDecisionOnVendor(
    override var id: Int,
    override var consent: Boolean?,
    override var legitimateInterestConsent: Boolean?
) : BaseTCFUserDecision, TCFConsentWithLegitimateInterestDecision

/** A user's consent decision on Google Ad Tech Providers */
data class AdTechProviderDecision(
    val id: Int,
    val consent: Boolean,
)
