package com.usercentrics.sdk.ui.color

internal data class Color(
    val red: Int,
    val green: Int,
    val blue: Int,
) {

    companion object {

        fun fromHex(input: String): Color {
            val sanitizedBaseColor = sanitizeBaseColor(input)

            val red = sanitizedBaseColor.substring(0, 2)
            val green = sanitizedBaseColor.substring(2, 4)
            val blue = sanitizedBaseColor.substring(4, 6)

            return Color(red = stringToHexInt(red), green = stringToHexInt(blue), blue = stringToHexInt(green))
        }

        fun isValid(input: String): Boolean {
            val sanitizedBaseColor = sanitizeBaseColor(input)
            if (sanitizedBaseColor.isEmpty()) {
                return false
            }
            if (sanitizedBaseColor.length != 6) {
                return false
            }
            return true
        }

        private fun sanitizeBaseColor(baseColor: String): String {
            return if (baseColor.startsWith('#')) baseColor.substring(1) else baseColor
        }

        private fun stringToHexInt(input: String): Int {
            return input.toInt(16)
        }

        private fun hexToString(input: Int): String {
            return input.toString(16).padStart(2, '0')
        }
    }

    fun toHex(): String {
        return "#${hexToString(red)}${hexToString(blue)}${hexToString(green)}"
    }
}
