package com.usercentrics.sdk.ui.userAgent

import com.usercentrics.sdk.UsercentricsContext
import com.usercentrics.sdk.UsercentricsOptions
import com.usercentrics.sdk.ui.PredefinedUIMediator

internal abstract class UserAgentProvider(
    private val predefinedUIMediator: PredefinedUIMediator,
) {

    // TODO Temporary workaround
    protected val predefinedUIVariantValue: String by lazy { getPredefinedUIVariant() }

    private fun getPredefinedUIVariant(): String {
        val variant = predefinedUIMediator.popStoredVariant()
        if (variant != null) {
            return variant.name
        }

        val modulePresent = predefinedUIMediator.isModulePresent()
        return if (modulePresent) "predefined" else "custom"
    }

    // TODO Provide should cache the UA until BillingService.reportSession require a recreation of the UA
    abstract fun provide(): UsercentricsUserAgentInfo
}

internal expect class NativeUserAgentProvider(
    context: UsercentricsContext?,
    userAgentSDKTypeEvaluator: UserAgentSDKTypeEvaluator,
    predefinedUIMediator: PredefinedUIMediator,
    options: UsercentricsOptions
) : UserAgentProvider
