package com.usercentrics.sdk.v2.async.dispatcher

internal class DispatcherCallback<T> {
    private var result: Result<T>? = null
    private var failureBlock: ((Throwable) -> Unit)? = null
    private var successBlock: ((T) -> Unit)? = null

    fun onFailure(block: (Throwable) -> Unit): DispatcherCallback<T> {
        result?.onFailure(block) ?: run {
            failureBlock = block
        }
        return this
    }

    fun onSuccess(block: (T) -> Unit): DispatcherCallback<T> {
        result?.onSuccess(block) ?: run {
            successBlock = block
        }
        return this
    }

    internal fun setResult(result: Result<T>) {
        this.result = result
        failureBlock?.run {
            failureBlock = null
            result.onFailure(this)
        }
        successBlock?.run {
            successBlock = null
            result.onSuccess(this)
        }
    }
}
