package com.usercentrics.sdk.v2.async.dispatcher

import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.async

internal class DispatcherScope(
    private val asyncDispatcher: CoroutineDispatcher
) {

    fun <T> async(block: suspend () -> T): Deferred<T> {
        val async = asyncDispatcher.scope().async { block() }
        return Deferred(async)
    }
}
