package com.usercentrics.sdk.v2.async.dispatcher

import com.usercentrics.sdk.errors.UsercentricsTimeoutException
import com.usercentrics.sdk.getTimeInMillis
import kotlin.concurrent.Volatile

internal class MainSemaphore : Semaphore {

    internal var timeout = 15000

    @Volatile
    private var waitingQueue = 0

    @Volatile
    private var current = 0

    override fun acquire() {
        if (waitingQueue == 0) {
            current = 1
        }

        val myPosition = ++waitingQueue

        val initialThreadTime = getTimeInMillis()
        while (true) {
            val elapsedTime = getTimeInMillis() - initialThreadTime
            if (elapsedTime >= timeout) {
                release()
                throw UsercentricsTimeoutException()
            }

            if (myPosition == current) {
                return
            }
        }
    }

    override fun release() {
        current++
    }
}
