package com.usercentrics.sdk.v2.banner.service.mapper

import com.usercentrics.sdk.models.settings.PredefinedUIFooterButton

internal class FooterButtonLayoutMapper(
    private val acceptAll: PredefinedUIFooterButton? = null,
    private val denyAll: PredefinedUIFooterButton? = null,
    private val saveSettings: PredefinedUIFooterButton? = null,
    private val okButton: PredefinedUIFooterButton? = null,
    private val manageSettings: PredefinedUIFooterButton? = null,
) {

    fun mapButtons(): List<List<PredefinedUIFooterButton>> = listOfNotNull(
        mapButtonsRow(denyAll, acceptAll),
        mapButtonsRow(okButton),
        mapButtonsRow(saveSettings),
        mapButtonsRow(manageSettings)
    )

    fun mapButtonsLandscape(): List<List<PredefinedUIFooterButton>> = listOfNotNull(
        mapButtonsRow(manageSettings, okButton, saveSettings, denyAll, acceptAll)
    )

    private fun mapButtonsRow(vararg buttons: PredefinedUIFooterButton?): List<PredefinedUIFooterButton>? {
        val buttonsTypeAll = buttons.filterNotNull().map {
            PredefinedUIFooterButton(
                label = it.label,
                customization = it.customization,
                type = it.type
            )
        }
        return if (buttonsTypeAll.isNotEmpty()) buttonsTypeAll else null
    }
}
