package com.usercentrics.sdk.v2.banner.service.mapper

import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings

internal open class GenericSecondLayerMapper(
    private val settings: UsercentricsSettings
) {

    fun predefinedUIServiceConsent(legacyConsent: LegacyConsent): PredefinedUIServiceConsent {
        val history = legacyConsent.history.map {
            PredefinedUIHistoryEntry(
                status = it.status,
                decisionText = historyDecisionText(it),
                formattedDate = it.formattedDate)
        }

        return PredefinedUIServiceConsent(history = history, status = legacyConsent.status)
    }

    private fun historyDecisionText(history: LegacyConsentHistoryEntry): String {
        return when {
            history.status && history.type == UsercentricsConsentType.IMPLICIT -> {
                settings.labels.yesImplicit
            }

            !history.status && history.type == UsercentricsConsentType.IMPLICIT -> {
                settings.labels.noImplicit
            }

            !history.status && history.type == UsercentricsConsentType.EXPLICIT -> {
                settings.labels.no
            }

            else -> {
                settings.labels.yes
            }
        }
    }
}
