package com.usercentrics.sdk.v2.banner.service.mapper.ccpa

import com.usercentrics.sdk.UsercentricsAnalyticsEventType
import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.v2.banner.service.mapper.FooterButtonLayoutMapper
import com.usercentrics.sdk.v2.banner.service.mapper.PoweredByMapper
import com.usercentrics.sdk.v2.settings.data.FirstLayerCloseOption
import com.usercentrics.sdk.v2.settings.data.FirstLayerLogoPosition
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings

internal class CCPAFirstLayerMapper(
    private val settings: UsercentricsSettings,
    private val customization: PredefinedUICustomization,
    private val optOutToggleInitialValue: Boolean
) {

    companion object {
        private val defaultLogoPosition = FirstLayerLogoPosition.LEFT
    }

    fun map(): UCUIFirstLayerSettings {
        return UCUIFirstLayerSettings(
            layout = settings.ccpa?.firstLayerMobileVariant ?: UCUIFirstLayerSettings.defaultLayout,
            headerSettings = header(),
            footerSettings = footer(),
            contentSettings = emptyList()
        )
    }

    private fun header(): PredefinedUIHeaderSettings {
        val shortDescription = if (settings.ccpa!!.firstLayerMobileDescriptionIsActive) settings.ccpa.firstLayerMobileDescription else null
        return PredefinedUIFirstLayerHeaderSettings(
            shortDescription = shortDescription,
            contentDescription = settings.ccpa.appFirstLayerDescription ?: "",
            title = settings.ccpa.firstLayerTitle,
            logoPosition = settings.firstLayer?.logoPosition ?: defaultLogoPosition,
            language = null,
            logoURL = settings.customization?.logoUrl,
            links = headerLinks(),
            firstLayerCloseLink = null,
            firstLayerCloseIcon = settings.firstLayer?.closeOption?.equals(FirstLayerCloseOption.ICON),
            readMoreText = settings.labels.btnBannerReadMore
        )
    }

    private fun headerLinks(): List<PredefinedUILink> {
        return listOf(
            PredefinedUILink.legalLinkUrl(
                label = settings.labels.privacyPolicyLinkText,
                url = settings.privacyPolicyUrl,
                eventType = UsercentricsAnalyticsEventType.PRIVACY_POLICY_LINK,
            ),
            PredefinedUILink.legalLinkUrl(
                label = settings.labels.imprintLinkText,
                url = settings.imprintUrl,
                eventType = UsercentricsAnalyticsEventType.IMPRINT_LINK,
            )
        ).filter { !it.isEmpty() }
    }

    private fun footer(): PredefinedUIFooterSettings {
        val optOutToggle = if (!settings.ccpa!!.removeDoNotSellToggle) {
            PredefinedUIFooterEntry(settings.ccpa.optOutNoticeLabel)
        } else {
            null
        }
        val poweredBy = LegacyPoweredBy(
            isEnabled = settings.enablePoweredBy,
        )
        val buttonLayoutMapper = FooterButtonLayoutMapper(
            okButton = PredefinedUIFooterButton(
                label = settings.ccpa.btnSave,
                customization = customization.color.okButton,
                type = PredefinedUIButtonType.OK
            ),
            manageSettings = PredefinedUIFooterButton(
                label = settings.ccpa.btnMoreInfo,
                customization = customization.color.manageButton,
                type = PredefinedUIButtonType.MANAGE_SETTINGS
            ),
        )
        return PredefinedUIFooterSettings(
            poweredBy = PoweredByMapper.mapPoweredBy(poweredBy),
            optOutToggle = optOutToggle,
            optOutToggleInitialValue = optOutToggleInitialValue,
            buttons = buttonLayoutMapper.mapButtons(),
            buttonsLandscape = buttonLayoutMapper.mapButtonsLandscape(),
        )
    }
}
