package com.usercentrics.sdk.v2.banner.service.mapper.gdpr

import com.usercentrics.sdk.models.settings.LegacyService
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerDetailsEntry
import com.usercentrics.sdk.models.settings.PredefinedUIServiceLabels
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings

internal class GDPRDetailsMapperTV(
    private val settings: UsercentricsSettings,
    private val labels: PredefinedUIServiceLabels,
) {
    fun map(service: LegacyService): List<PredefinedTVSecondLayerDetailsEntry> {
        return listOfNotNull(
            getServiceDescription(service),
            getProcessingCompany(service),
            getDataPurposes(service),
            getTechnologiesUsed(service),
            getDataCollected(service),
            getLegalBasis(service),
            getProcessingLocation(service),
            getRetentionPeriod(service),
            getThirdPartyCountriesDistribution(service),
            getDataRecipients(service),
            getPrivacyPolicy(service),
            getCookiePolicy(service),
            getOptOutLink(service),
            getDataProcessingAgreement(service),
//            getHistory(service)
        )
    }

    private fun getServiceDescription(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        return if (service.serviceDescription.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.descriptionTitle,
                content = service.serviceDescription
            )
        } else {
            null
        }
    }

    private fun getProcessingCompany(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val processingCompanyBld = StringBuilder()
        val name = service.processingCompany.name
        if (name.isNotBlank()) {
            processingCompanyBld.append(name)
        }
        val address = service.processingCompany.address
        if (address.isNotBlank()) {
            if (processingCompanyBld.isNotEmpty()) {
                processingCompanyBld.append("\n")
            }
            processingCompanyBld.append(address)
        }
        val processingCompany = processingCompanyBld.toString()
        return if (processingCompany.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.processingCompanyTitle,
                content = processingCompany
            )
        } else {
            null
        }
    }

    private fun getDataPurposes(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val dataPurposes = service.dataPurposes.filterNotBlank()
        return if (dataPurposes.isNotEmpty()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.dataPurposes.title,
                content = PredefinedTVSecondLayerDetailsEntry.mapContent(dataPurposes, labels.dataPurposes.titleDescription)
            )
        } else {
            null
        }
    }

    private fun getTechnologiesUsed(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val technologiesUsed = service.technologiesUsed.filterNotBlank()
        return if (technologiesUsed.isNotEmpty()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.technologiesUsed.title,
                content = PredefinedTVSecondLayerDetailsEntry.mapContent(technologiesUsed, labels.technologiesUsed.titleDescription)
            )
        } else {
            null
        }
    }

    private fun getDataCollected(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val dataCollected = service.dataCollected.filterNotBlank()
        return if (dataCollected.isNotEmpty()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.dataCollected.title,
                content = PredefinedTVSecondLayerDetailsEntry.mapContent(dataCollected, labels.dataCollected.titleDescription)
            )
        } else {
            null
        }
    }

    private fun getLegalBasis(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val legalBasisList = service.legalBasis.filterNotBlank()
        return if (legalBasisList.isNotEmpty()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.legalBasis.title,
                content = PredefinedTVSecondLayerDetailsEntry.mapContent(legalBasisList, labels.legalBasis.titleDescription)
            )
        } else {
            null
        }
    }

    private fun getProcessingLocation(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val processingLocation = service.dataDistribution.processingLocation
        return if (processingLocation.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.dataDistribution.processingLocationTitle,
                content = processingLocation,
            )
        } else {
            null
        }
    }

    private fun getRetentionPeriod(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        return if (service.retentionPeriodDescription.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.retentionPeriodTitle,
                content = service.retentionPeriodDescription
            )
        } else {
            null
        }
    }

    private fun getThirdPartyCountriesDistribution(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val thirdPartyCountries = service.dataDistribution.thirdPartyCountries
        return if (thirdPartyCountries.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.dataDistribution.thirdPartyCountriesTitle,
                content = PredefinedTVSecondLayerDetailsEntry.mapContent(listOf(thirdPartyCountries), labels.dataDistribution.thirdPartyCountriesDescription)
            )
        } else {
            null
        }
    }

    private fun getDataRecipients(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val dataRecipients = service.dataRecipients.filterNotBlank()
        return if (dataRecipients.isNotEmpty()) {
            PredefinedTVSecondLayerDetailsEntry.TitleContent(
                title = labels.dataRecipientsTitle,
                content = PredefinedTVSecondLayerDetailsEntry.mapContent(dataRecipients)
            )
        } else {
            null
        }
    }

    private fun getPrivacyPolicy(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val privacyPolicy = service.urls.privacyPolicy
        return if (privacyPolicy.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.Link(
                title = settings.labels.privacyPolicyLinkText,
                linkLabel = labels.urls.privacyPolicyTitle,
                url = privacyPolicy,
            )
        } else {
            null
        }
    }

    private fun getCookiePolicy(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val cookiePolicy = service.urls.cookiePolicy
        return if (cookiePolicy.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.Link(
                title = settings.labels.cookiePolicyLinkText,
                linkLabel = labels.urls.cookiePolicyTitle,
                url = cookiePolicy,
            )
        } else {
            null
        }
    }

    private fun getOptOutLink(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val optOut = service.urls.optOut
        return if (optOut.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.Link(
                title = settings.labels.furtherInformationOptOut,
                linkLabel = labels.urls.optOutTitle,
                url = optOut,
            )
        } else {
            null
        }
    }

    private fun getDataProcessingAgreement(service: LegacyService): PredefinedTVSecondLayerDetailsEntry? {
        val dataProcessingAgreement = service.urls.dataProcessingAgreement
        return if (dataProcessingAgreement.isNotBlank()) {
            PredefinedTVSecondLayerDetailsEntry.Link(
                title = settings.labels.linkToDpaInfo,
                linkLabel = dataProcessingAgreement,
                url = dataProcessingAgreement,
            )
        } else {
            null
        }
    }

    private fun <T : CharSequence> Iterable<T>.filterNotBlank(): List<T> {
        val destination = ArrayList<T>()
        for (element in this) if (element.isNotBlank()) destination.add(element)
        return destination
    }
}
