package com.usercentrics.sdk.v2.banner.service.mapper.tcf

import com.usercentrics.sdk.AdTechProvider
import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.models.tcf.TCFLabels
import com.usercentrics.sdk.services.tcf.interfaces.TCFData
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization

internal class TCFViewSettingsMapper(
    private val settings: UsercentricsSettings,
    private val customization: PredefinedUICustomization,
    private val labels: TCFLabels,
    translations: LegalBasisLocalization,
    tcfData: TCFData,
    categories: List<UsercentricsCategory>,
    services: List<LegacyService>,
    controllerId: String,
    adTechProviders: List<AdTechProvider>,
) {

    private val firstLayerMapper = TCFFirstLayerMapper(settings, tcfData, customization, categories, services)
    private val secondLayerMapper = TCFSecondLayerMapper(settings, tcfData, translations, customization, categories, services, labels, controllerId, adTechProviders)

    fun map(): PredefinedUIViewSettings {
        return PredefinedUIViewSettings(
            customization = customization,
            internationalizationLabels = labels(),
            firstLayerV2 = firstLayerMapper.map(),
            secondLayerV2 = secondLayerMapper.map(),
        )
    }

    fun mapTV(): PredefinedTVViewSettings {
        return PredefinedTVViewSettings(
            customization = customization,
            firstLayer = firstLayerMapper.mapTV(),
            secondLayer = secondLayerMapper.mapTV(),
            ariaLabels = labels.nonTCFLabels.ariaLabels,
        )
    }

    private fun labels(): PredefinedUILabels {
        val buttonLabels = FirstLayerButtonLabels(
            acceptAll = settings.tcf2!!.buttonsAcceptAllLabel,
            denyAll = settings.tcf2.buttonsDenyAllLabel,
            more = settings.tcf2.linksManageSettingsLabel,
            save = settings.tcf2.buttonsSaveLabel,
        )
        return PredefinedUILabels(
            general = labels.nonTCFLabels.general,
            service = labels.nonTCFLabels.service,
            firstLayerButtonLabels = buttonLabels,
            cookieInformationLabels = labels.cookieInformation,
            ariaLabels = labels.nonTCFLabels.ariaLabels,
        )
    }
}
