package com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo

import com.usercentrics.sdk.models.settings.PredefinedUICookieInformationLabels
import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent
import com.usercentrics.sdk.v2.settings.data.ConsentDisclosureObject
import com.usercentrics.sdk.v2.settings.data.ConsentDisclosureType
import com.usercentrics.tcf.core.model.gvl.Purpose

internal class DeviceStorageMapper(
    private val deviceStorage: ConsentDisclosureObject,
    private val cookieInformationLabels: PredefinedUICookieInformationLabels,
    private val purposes: Map<String, Purpose>
) {

    fun map(): List<PredefinedUIDeviceStorageContent> {
        return deviceStorage.disclosures.map { item ->
            val cardContent = mutableListOf<String>()
            item.type?.let {
                val typeText = "${cookieInformationLabels.type}: ${it.name.lowercase()}"
                cardContent.add(typeText)
            }

            if (item.type == ConsentDisclosureType.COOKIE) {
                val maxAgeSeconds = item.maxAgeSeconds ?: 0
                val duration: String = if (maxAgeSeconds > 0) {
                    cookieInformationLabels.cookieMaxAgeLabel(maxAgeSeconds.toDouble())
                } else {
                    "-"
                }

                val durationText = "${cookieInformationLabels.duration}: $duration"
                cardContent.add(durationText)

                val cookieRefresh = item.cookieRefresh
                val cookieRefreshLabel = if (cookieRefresh) cookieInformationLabels.yes else cookieInformationLabels.no
                cardContent.add("${cookieInformationLabels.cookieRefresh}: $cookieRefreshLabel")
            }

            val domain = item.domain ?: ""
            if (domain.isNotBlank()) {
                val domainValue: String = if (item.domain == "*") {
                    cookieInformationLabels.anyDomain
                } else {
                    if (domain.contains("*")) {
                        cookieInformationLabels.multipleDomains
                    } else {
                        domain
                    }
                }
                val domainText = "${cookieInformationLabels.domain}: $domainValue"
                cardContent.add(domainText)
            }

            val purposes: String = item.purposes.mapNotNull {
                val purpose = it.toString()
                purposes[purpose]?.name
            }.joinToString { it }

            if (purposes.isNotBlank()) {
                cardContent.add("${cookieInformationLabels.purposes}: $purposes")
            }

            val titleName = if (item.identifier.isNullOrBlank()) (item.name ?: "") else item.identifier
            val title = "${cookieInformationLabels.identifier}: $titleName"
            PredefinedUIDeviceStorageContent(title = title, content = cardContent)
        }
    }
}
