package com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo

import com.usercentrics.sdk.forceHttps
import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.v2.settings.data.ConsentDisclosureObject

internal class TCFStorageInformationMapper(
    private val holder: TCFStorageInformationHolder,
    private val showShortDescription: Boolean
) {

    fun map(): PredefinedUIServiceContentSection {
        val content = StringBuilder()

        if (showShortDescription) {
            content.append(holder.cookieInformationLabels.storageInformationDescription)
            content.append("\n\n")
        }

        val usesCookies = holder.usesCookies

        usesCookies?.let {
            val cookieStorage = if (it) holder.cookieInformationLabels.yes else holder.cookieInformationLabels.no
            content.append("${PredefinedUIData.BULLET_POINT} ${holder.cookieInformationLabels.cookieStorage}: $cookieStorage\n")
        }

        appendCookiesInformation(content)

        val nonCookieStorage = if (holder.usesNonCookieAccess == true) holder.cookieInformationLabels.yes else holder.cookieInformationLabels.no
        content.append("${PredefinedUIData.BULLET_POINT} ${holder.cookieInformationLabels.nonCookieStorage}: $nonCookieStorage")

        return PredefinedUIServiceContentSection(
            title = holder.cookieInformationLabels.title,
            content = PredefinedUIStorageInformationServiceContent(
                content = content.toString(),
                button = storageInformationButtonInfo()
            )
        )
    }

    private fun appendCookiesInformation(content: StringBuilder) {
        val cookieMaxAgeInSeconds = holder.cookieMaxAgeSeconds
        if (cookieMaxAgeInSeconds != null) {
            val cookieAge = holder.cookieInformationLabels.cookieMaxAgeLabel(cookieMaxAgeInSeconds.toDouble())
            content.append("${PredefinedUIData.BULLET_POINT} ${holder.cookieInformationLabels.maximumAge}: $cookieAge")
            content.append("\n")
        }

        val cookieRefresh = holder.cookieRefresh
        if (cookieRefresh != null) {
            val cookieRefreshLabel = if (cookieRefresh) holder.cookieInformationLabels.yes else holder.cookieInformationLabels.no
            content.append("${PredefinedUIData.BULLET_POINT} ${holder.cookieInformationLabels.cookieRefresh}: $cookieRefreshLabel")
            content.append("\n")
        }
    }

    private fun storageInformationButtonInfo(): PredefinedUIStorageInformationButtonInfo? {
        val deviceStorage = holder.deviceStorage
        val deviceStorageDisclosureUrl = holder.deviceStorageDisclosureUrl?.forceHttps()

        val hideStorageInfoButton = deviceStorage?.disclosures?.isEmpty() ?: true && deviceStorageDisclosureUrl.isNullOrBlank()
        if (hideStorageInfoButton) {
            return null
        }

        return PredefinedUIStorageInformationButtonInfo(
            label = holder.cookieInformationLabels.titleDetailed,
            url = deviceStorageDisclosureUrl,
            deviceStorage = mapDeviceStorageContent(deviceStorage)
        )
    }

    private fun mapDeviceStorageContent(deviceStorage: ConsentDisclosureObject?): List<PredefinedUIDeviceStorageContent>? {
        if (deviceStorage == null) {
            return null
        }
        return DeviceStorageMapper(deviceStorage, holder.cookieInformationLabels, mapOf()).map()
    }
}
