package com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo

import com.usercentrics.sdk.services.tcf.interfaces.TCFVendor
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings
import com.usercentrics.tcf.core.model.gvl.VendorUrl

fun getVendorUrls(vendor: TCFVendor, settings: UsercentricsSettings): VendorUrl? {
    val chosenLanguage = vendor.vendorUrls.firstOrNull { it.langId == settings.language }
    val englishLanguage = vendor.vendorUrls.firstOrNull { it.langId == "en" }
    val firstAvailableLanguage = vendor.vendorUrls.firstOrNull()

    return when {
        chosenLanguage != null -> chosenLanguage
        englishLanguage != null -> englishLanguage
        firstAvailableLanguage != null -> firstAvailableLanguage
        else -> null
    }
}
