package com.usercentrics.sdk.v2.consent.data

import com.usercentrics.sdk.BuildKonfig
import com.usercentrics.sdk.core.time.DateTime
import com.usercentrics.sdk.extensions.millisToSeconds
import com.usercentrics.sdk.models.settings.LegacyService
import com.usercentrics.sdk.models.settings.UsercentricsConsentAction
import com.usercentrics.sdk.models.settings.UsercentricsConsentType
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class DataTransferObject(
    val applicationVersion: String,
    val consent: DataTransferObjectConsent,
    val settings: DataTransferObjectSettings,
    val services: List<DataTransferObjectService>, // INTERNAL
    @SerialName("timestamp")
    val timestampInSeconds: Long // INTERNAL
) {
    companion object {
        fun create(
            settings: UsercentricsSettings,
            controllerId: String,
            services: List<LegacyService>,
            consentAction: UsercentricsConsentAction,
            consentType: UsercentricsConsentType,
            timestampInMillis: Long? = null
        ): DataTransferObject {

            val selectedLanguage = settings.language

            return DataTransferObject(
                applicationVersion = BuildKonfig.sdk_version,
                consent = DataTransferObjectConsent(
                    action = consentAction,
                    type = consentType
                ),
                services = services.map { service ->
                    return@map DataTransferObjectService(
                        id = service.id,
                        name = service.name,
                        status = service.consent.status,
                        version = service.version,
                        processorId = service.processorId
                    )
                },
                settings = DataTransferObjectSettings(
                    id = settings.settingsId,
                    controllerId = controllerId,
                    language = selectedLanguage,
                    version = settings.version
                ),
                timestampInSeconds = (timestampInMillis ?: DateTime().timestamp()).millisToSeconds()
            )
        }
    }
}

@Serializable
internal data class DataTransferObjectConsent(
    val action: UsercentricsConsentAction,
    val type: UsercentricsConsentType
)

@Serializable
internal data class DataTransferObjectService(
    val id: String,
    val name: String,
    val status: Boolean,
    val version: String,
    val processorId: String
)

@Serializable
internal data class DataTransferObjectSettings(
    val id: String,
    val controllerId: String,
    val language: String,
    val version: String
)
