package com.usercentrics.sdk.v2.language.api

import com.usercentrics.sdk.BuildKonfig
import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.errors.UsercentricsException
import com.usercentrics.sdk.models.api.ApiErrors
import com.usercentrics.sdk.models.api.HttpConstants.FORBIDDEN_STATUS_CODE
import com.usercentrics.sdk.services.api.NetworkResolver

internal class LanguageApi(
    private val restClient: HttpRequests,
    private val networkResolver: NetworkResolver,
) : ILanguageApi {

    override suspend fun getAvailableLanguages(settingsId: String, version: String, headers: Map<String, String>): HttpResponse {
        val url = buildUrl(settingsId, version)
        return restClient.getSync2(url, headers).also {
            if (it.statusCode == FORBIDDEN_STATUS_CODE || it.statusCode == 404) {
                throw UsercentricsException(ApiErrors.AVAILABLE_LANGUAGES_SETTINGS_NOT_FOUND)
            }
        }
    }

    private fun buildUrl(settingsId: String, jsonFileVersion: String): String {
        val baseUrl = networkResolver.cdnBaseUrl()
        return "${baseUrl}/${BuildKonfig.endpoint_settingsUrlPath}/$settingsId/$jsonFileVersion/languages.json"
    }
}
