package com.usercentrics.sdk.v2.language.repository

import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.language.api.ILanguageApi
import com.usercentrics.sdk.v2.language.data.LanguageData
import com.usercentrics.sdk.v2.location.data.LocationAwareResponse
import com.usercentrics.sdk.v2.network.NetworkOrchestrator

internal class LanguageRepository(
    private val languageApi: ILanguageApi,
    private val jsonParser: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), ILanguageRepository {

    override suspend fun fetchAvailableLanguages(settingsId: String, version: String, bypassCache: Boolean): LocationAwareResponse<List<String>> {
        val response = resolveHttp2(bypassCache = bypassCache) { languageApi.getAvailableLanguages(settingsId, version, getApiHeaders()) }

        val languagesAvailable = parseJson(response.body).languagesAvailable
        return LocationAwareResponse(
            data = languagesAvailable,
            location = response.parseLocation(),
            languageEtagChanged = if (bypassCache) {
                true
            } else {
                shouldLoadFromApi(response.statusCode)
            }
        )
    }

    override fun etagKey(): String {
        return EtagCacheStorage.languagesDir
    }

    private fun parseJson(responseBody: String): LanguageData {
        return jsonParser.decodeFromString(responseBody)
    }
}
