package com.usercentrics.sdk.v2.location.cache

import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage
import com.usercentrics.sdk.services.deviceStorage.StorageKeys

internal class LocationCache(
    private val keyValueStorage: KeyValueStorage
) : ILocationCache {

    override fun getCachedLocation(): String? {
        return keyValueStorage.getString(StorageKeys.LOCATION_CACHE.text, null)
    }

    override fun storeLocation(location: String) {
        keyValueStorage.put(StorageKeys.LOCATION_CACHE.text, location)
    }

    override fun getInjectedLocation(): String? {
        return keyValueStorage.getString(StorageKeys.INJECTED_LOCATION.text, null)
    }
}
