package com.usercentrics.sdk.v2.location.data

import com.usercentrics.sdk.models.location.LocationConstants
import kotlinx.serialization.Serializable

@Serializable
data class UsercentricsLocation(
    val countryCode: String = "",
    val regionCode: String = ""
) {

    fun isInEU(): Boolean {
        return countryCode.uppercase() in LocationConstants.EU_COUNTRIES
    }

    fun isInUS(): Boolean {
        return countryCode == LocationConstants.US_COUNTRY_CODE
    }

    fun isInCalifornia(): Boolean {
        return countryCode == LocationConstants.US_COUNTRY_CODE &&
                (regionCode == LocationConstants.CALIFORNIA_REGION_CODE || regionCode.endsWith(LocationConstants.CALIFORNIA_REGION_CODE))
    }

    fun isEmpty(): Boolean {
        return countryCode == "" && regionCode == ""
    }
}
