package com.usercentrics.sdk.v2.location.service

import com.usercentrics.sdk.v2.location.data.UsercentricsLocation
import com.usercentrics.sdk.v2.location.repository.ILocationRepository

internal class LocationService(
    private val locationRepository: ILocationRepository,
) : ILocationService {

    override var location = UsercentricsLocation()

    override fun loadLocation(): Boolean {
        var location = locationRepository.getInjectedLocation()?.clientLocation

        if (isInvalidLocation(location)) {
            location = locationRepository.getCachedLocation()?.clientLocation
        }

        if (isInvalidLocation(location)) {
            return false
        }

        set(location!!)
        return true
    }

    override fun set(location: UsercentricsLocation) {
        if (isInvalidLocation(location)) {
            return
        }

        this.location = location
        locationRepository.storeLocation(location)
    }

    private fun isInvalidLocation(location: UsercentricsLocation?): Boolean {
        return location == null || location.isEmpty()
    }
}
