package com.usercentrics.sdk.v2.ruleset.api

import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.errors.UsercentricsException
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.models.api.ApiErrors
import com.usercentrics.sdk.models.api.HttpConstants
import com.usercentrics.sdk.services.api.NetworkResolver

internal class RuleSetApi(
    private val logger: UsercentricsLogger,
    private val networkResolver: NetworkResolver,
    private val restClient: HttpRequests,
) : IRuleSetApi {

    override suspend fun getRuleSet(id: String, headers: Map<String, String>): HttpResponse {
        try {
            val baseUrl = buildUrl(id)
            return restClient.getSync2(baseUrl, headers).also {
                if (it.statusCode == HttpConstants.FORBIDDEN_STATUS_CODE || it.statusCode == 404) {
                    throw UsercentricsException(ApiErrors.RULE_SET_NOT_FOUND)
                }
            }
        } catch (cause: Exception) {
            logger.error("Failed while fetching ruleSet using id: $id", cause)
            throw cause as? UsercentricsException ?: UsercentricsException(ApiErrors.FETCH_RULE_SET, cause)
        }
    }

    private fun buildUrl(id: String): String {
        return "${networkResolver.cdnBaseUrl()}/ruleSet/$id.json"
    }
}
