package com.usercentrics.sdk.v2.ruleset.data

import com.usercentrics.sdk.v2.location.data.UsercentricsLocation
import kotlinx.serialization.Serializable

@Serializable
internal data class RuleSet(
    val rules: List<GeoRule>,
    val defaultRule: DefaultGeoRule
)

@Serializable
internal data class GeoRule(
    val settingsId: String,
    val locations: List<String>
)

@Serializable
internal data class DefaultGeoRule(
    val settingsId: String,
    val noShow: Boolean
)

@Serializable
internal data class SessionGeoRule(
    val activeSettingsId: String,
    val noShow: Boolean,
    val location: UsercentricsLocation,
    val allSettingsIds: HashSet<String>,
)
