package com.usercentrics.sdk.v2.settings.api

import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.errors.UsercentricsException
import com.usercentrics.sdk.models.api.ApiErrors
import com.usercentrics.sdk.services.api.NetworkResolver
import com.usercentrics.sdk.v2.settings.data.BasicConsentTemplate

internal class AggregatorApi(
    private val logger: UsercentricsLogger,
    private val networkResolver: NetworkResolver,
    private val restClient: HttpRequests,
) : IAggregatorApi {

    override suspend fun getServices(language: String, services: List<BasicConsentTemplate>, headers: Map<String, String>): HttpResponse {
        val url = createAggregatorJsonUrl(language, services)
        try {
            return restClient.getSync2(url, headers)
        } catch (ex: Exception) {
            logger.error("Failed while fetching services", ex)
            throw UsercentricsException(ApiErrors.FETCH_DATA_PROCESSING_SERVICES, ex)
        }
    }

    private fun createAggregatorJsonUrl(language: String, services: List<BasicConsentTemplate>): String {
        val templatesValue = services.joinToString(separator = ",") { "${it.templateId}@${it.version}" }

        val baseUrl = networkResolver.aggregatorBaseUrl()
        return "$baseUrl/aggregate/$language?templates=$templatesValue"
    }
}
