package com.usercentrics.sdk.v2.settings.data

import kotlinx.serialization.Serializable

@Serializable
data class CCPASettings(
    // Required
    val optOutNoticeLabel: String,
    val btnSave: String,
    val firstLayerTitle: String,
    val secondLayerTitle: String,
    val secondLayerDescription: String,
    val btnMoreInfo: String,
    val firstLayerMobileVariant: FirstLayerMobileVariant? = null,

    // Optional
    // CCPA Enabled/Disabled (Main Toggle of AI)
    val isActive: Boolean = false,

    // Show the CCPA CMP only for users in this region
    val region: CCPARegion = CCPARegion.US_CA_ONLY,

    // Show the CCPA CMP on the first time
    val showOnPageLoad: Boolean = false,

    // Reshow the CMP in days
    val reshowAfterDays: Int = 365,

    // IAB LSPA Agreement exists
    val iabAgreementExists: Boolean = false,

    // Not need to show the CCPA toggle
    val removeDoNotSellToggle: Boolean = false,

    val appFirstLayerDescription: String? = null,
    val firstLayerMobileDescriptionIsActive: Boolean = false,
    val firstLayerMobileDescription: String? = null,
    val secondLayerHideLanguageSwitch: Boolean = false,
)

enum class CCPARegion {
    US_CA_ONLY,
    US,
    ALL,
}
