package com.usercentrics.sdk.v2.settings.data

import kotlinx.serialization.Serializable

@Serializable
data class FirstLayer(
    val hideButtonDeny: Boolean? = null,
    val logoPosition: FirstLayerLogoPosition? = null,
    val secondLayerTrigger: SecondLayerTrigger? = null,
    val closeOption: FirstLayerCloseOption? = null,
    val mobileVariant: FirstLayerMobileVariant? = null,
)

enum class FirstLayerCloseOption {
    LINK, // CNIL
    ICON,
}

enum class FirstLayerLogoPosition {
    LEFT,
    CENTER,
    RIGHT
}
